#!/bin/bash
MODEL_PATH=$1
set -e # exit on error
pred_file=${MODEL_PATH}/vizwiz_val/answers/merge.jsonl

python inf_qwen_vl.py eval \
        --model-path ${MODEL_PATH} \
        --question-file <DATA_FOLDER>/vizwiz/val.llava_eval.jsonl  \
        --image-folder <DATA_FOLDER>/vizwiz/images/val \
        --answer-file ${pred_file}


output_file=${MODEL_PATH}/vizwiz_val/pred_probs_only_yes_or_no/merge.jsonl
python inf_qwen_vl.py get_pred_prob_only_yes_or_no \
        --model-path ${MODEL_PATH} \
        --question-file <DATA_FOLDER>/vizwiz/val.llava_eval.jsonl  \
        --image-folder <DATA_FOLDER>/vizwiz/images/val \
        --pred_file ${pred_file} \
        --answer-file ${output_file} 

